/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.colorpalette;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.ui.component.DropDownItem;
import journeymap.client.ui.component.SelectableParent;
import journeymap.client.ui.component.buttons.DropDownButton;
import net.minecraft.class_2561;
import net.minecraft.class_4185;

public class PaletteDropDownButton
extends DropDownButton {
    static String currentPalette = "all";
    private final DropDownItem all = new DropDownItem((SelectableParent)this, (Object)"all", Constants.getString("jm.colorpalette.palette", Constants.getString("jm.colorpalette.palette_all")), "");

    public PaletteDropDownButton(boolean global, boolean world, class_4185.class_4241 onPress) {
        super("", onPress);
        this.setItems(this.createListItems(global, world));
        this.setSelected(currentPalette);
    }

    private List<DropDownItem> createListItems(boolean global, boolean world) {
        ArrayList list = Lists.newArrayList();
        list.add(this.all);
        if (global) {
            list.add(new DropDownItem((SelectableParent)this, (Object)"global", Constants.getString("jm.colorpalette.global"), ""));
        }
        if (world) {
            list.add(new DropDownItem((SelectableParent)this, (Object)"world", Constants.getString("jm.colorpalette.world"), ""));
        }
        return list;
    }

    private void setSelected(String palette) {
        this.selected = null;
        for (DropDownItem item : this.items) {
            if (!palette.equals(item.getId())) continue;
            this.selected = item;
            break;
        }
        if (this.selected == null) {
            this.selected = this.all;
        }
        this.method_25355((class_2561)class_2561.method_43470((String)this.selected.getLabel()));
        currentPalette = (String)this.selected.getId();
    }

    public void setValidPalettes(boolean global, boolean world) {
        this.items.clear();
        this.setItems(this.createListItems(global, world));
        this.setSelected(currentPalette);
    }

    @Override
    public void setSelected(DropDownItem selectedButton) {
        currentPalette = (String)selectedButton.getId();
        super.setSelected(selectedButton);
    }
}

