/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import journeymap.client.io.FileHandler;
import journeymap.client.io.IconSetFileHandler;
import journeymap.client.io.ThemeLoader;
import journeymap.client.task.main.ExpireTextureTask;
import journeymap.client.texture.DynamicTextureImpl;
import journeymap.client.texture.IgnSkin;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.SimpleTextureImpl;
import journeymap.client.texture.Texture;
import journeymap.client.ui.theme.Theme;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.thread.JMThreadFactory;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class TextureCache {
    public static final class_2960 TOGGLE_ON = TextureCache.uiImage("toggle-button-on.png");
    public static final class_2960 TOGGLE_OFF = TextureCache.uiImage("toggle-button-off.png");
    public static final class_2960 GridSquares = TextureCache.uiImage("grid.png");
    public static final class_2960 GridRegionSquares = TextureCache.uiImage("grid-region.png");
    public static final class_2960 GridRegion = TextureCache.uiImage("region.png");
    public static final class_2960 ColorPicker = TextureCache.uiImage("colorpick.png");
    public static final class_2960 ColorPicker2 = TextureCache.uiImage("colorpick2.png");
    public static final class_2960 TileSampleDay = TextureCache.uiImage("tile-sample-day.png");
    public static final class_2960 TileSampleNight = TextureCache.uiImage("tile-sample-night.png");
    public static final class_2960 TileSampleUnderground = TextureCache.uiImage("tile-sample-underground.png");
    public static final class_2960 UnknownEntity = TextureCache.uiImage("unknown.png");
    public static final class_2960 Deathpoint = TextureCache.uiImage("waypoint-death-icon.png");
    public static final class_2960 MobDot = TextureCache.uiImage("marker-dot-160.png");
    public static final class_2960 MobDotArrow = TextureCache.uiImage("marker-dot-arrow-160.png");
    public static final class_2960 MobDotChevron = TextureCache.uiImage("marker-chevron-160.png");
    public static final class_2960 MobIconArrow = TextureCache.uiImage("marker-icon-arrow-160.png");
    public static final class_2960 MobIconArrowBG = TextureCache.uiImage("marker-icon-arrow-bg-160.png");
    public static final class_2960 MobIcon = TextureCache.uiImage("marker-icon-160.png");
    public static final class_2960 MobIconBG = TextureCache.uiImage("marker-icon-bg-160.png");
    public static final class_2960 MobIconMask = TextureCache.uiImage("marker-icon-mask.png");
    public static final class_2960 PlayerArrow = TextureCache.uiImage("marker-player-160.png");
    public static final class_2960 PlayerArrowBG = TextureCache.uiImage("marker-player-bg-160.png");
    public static final class_2960 PlayerOutline = TextureCache.uiImage("marker-player-outline.png");
    public static final class_2960 Logo = TextureCache.uiImage("ico/journeymap.png");
    public static final class_2960 MinimapSquare128 = TextureCache.uiImage("minimap/minimap-square-128.png");
    public static final class_2960 MinimapSquare256 = TextureCache.uiImage("minimap/minimap-square-256.png");
    public static final class_2960 MinimapSquare512 = TextureCache.uiImage("minimap/minimap-square-512.png");
    public static final class_2960 Discord = TextureCache.uiImage("discord.png");
    public static final class_2960 CurseForge = TextureCache.uiImage("curseforge.png");
    public static final class_2960 Modrinth = TextureCache.uiImage("modrinth.png");
    public static final class_2960 ColorWheel = TextureCache.uiImage("colorwheel.png");
    public static final class_2960 ColorWheelHandler = TextureCache.uiImage("colorwheel-handler.png");
    public static final class_2960 ColorBox = TextureCache.uiImage("color-box.png");
    public static final class_2960 ColorVSlider = TextureCache.uiImage("color-v-slider.png");
    public static final class_2960 ColorVSliderHandler = TextureCache.uiImage("color-v-slider-handler.png");
    public static final class_2960 ColorHistoryButton = TextureCache.uiImage("color-history-button.png");
    public static final class_2960 Flag = TextureCache.uiImage("flag.png");
    public static final class_2960 Waypoint = TextureCache.uiImage("waypoint-icon.png");
    public static final class_2960 WaypointEdit = TextureCache.uiImage("waypoint-edit.png");
    public static final class_2960 WaypointOffscreen = TextureCache.uiImage("waypoint-offscreen.png");
    private static final Map<String, class_2960> dynamicTextureMap = Collections.synchronizedMap(new HashMap());
    public static final Map<String, Texture> colorizedWPIconMap = Collections.synchronizedMap(new HashMap());
    public static final Map<class_2960, class_2960> modTextureMap = Collections.synchronizedMap(new HashMap());
    public static final Map<String, Texture> playerSkins = Collections.synchronizedMap(new HashMap());
    public static final Map<String, Texture> themeImages = Collections.synchronizedMap(new HashMap());
    private static ThreadPoolExecutor texExec = new ThreadPoolExecutor(2, 4, 15L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(8), new JMThreadFactory("texture"), new ThreadPoolExecutor.CallerRunsPolicy());
    public static final Map<String, class_2960> waypointIconCache = Collections.synchronizedMap(new HashMap<String, class_2960>(){
        {
            this.put(Waypoint.toString(), Waypoint);
            this.put(Deathpoint.toString(), Deathpoint);
        }
    });

    public static class_2960 getTexture(String texturePath) {
        class_2960 tex = dynamicTextureMap.get(texturePath);
        if (tex == null) {
            tex = TextureCache.uiImage(texturePath);
            dynamicTextureMap.put(texturePath, tex);
        }
        return tex;
    }

    public static class_2960 uiImage(String fileName) {
        return class_2960.method_60655((String)"journeymap", (String)("ui/img/" + fileName));
    }

    public static Texture getTexture(class_2960 location) {
        if (location == null) {
            return null;
        }
        class_1060 textureManager = class_310.method_1551().method_1531();
        Object textureObject = textureManager.method_34590(location, null);
        if (TextureCache.needsNewTexture(textureObject)) {
            textureObject = new SimpleTextureImpl(location);
            textureManager.method_4616(location, textureObject);
        }
        try {
            Texture tex = (Texture)textureObject;
            return tex;
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Not a proper texture for Journeymap:{}", (Object)location);
            return (Texture)textureObject;
        }
    }

    public static Texture getWaypointIcon(class_2960 location) {
        if (!"journeymap".equals(location.method_12836())) {
            class_1060 manager = class_310.method_1551().method_1531();
            class_2960 fakeResource = modTextureMap.get(location);
            if (fakeResource == null || manager.method_34590(fakeResource, null) == null) {
                fakeResource = class_2960.method_60655((String)"fake", (String)location.method_12832());
                modTextureMap.put(location, fakeResource);
                try (SimpleTextureImpl simpleTexture = new SimpleTextureImpl(location);){
                    class_1011 img = ImageUtil.getScaledImage(4.0f, simpleTexture.getNativeImage(), false);
                    DynamicTextureImpl scaledTexture = new DynamicTextureImpl(img, fakeResource);
                    manager.method_4616(fakeResource, (class_1044)scaledTexture);
                    scaledTexture.setDisplayHeight(simpleTexture.getHeight());
                    scaledTexture.setDisplayWidth(simpleTexture.getHeight());
                }
            }
            return (Texture)manager.method_34590(fakeResource, null);
        }
        return TextureCache.getTexture(location);
    }

    private static boolean needsNewTexture(class_1044 textureObject) {
        if (textureObject == null) {
            return true;
        }
        if (textureObject instanceof Texture) {
            return !((Texture)textureObject).hasImage();
        }
        return textureObject instanceof class_1049;
    }

    public static <T extends Texture> Future<T> scheduleTextureTask(Callable<T> textureTask) {
        return texExec.submit(textureTask);
    }

    public static void reset() {
        playerSkins.clear();
        Arrays.asList(ColorPicker, ColorPicker2, Deathpoint, GridSquares, GridRegionSquares, GridRegion, Logo, MinimapSquare128, MinimapSquare256, MinimapSquare512, MobDot, MobDotArrow, MobDotChevron, PlayerArrow, PlayerArrowBG, PlayerArrowBG, TileSampleDay, TileSampleNight, TileSampleUnderground, UnknownEntity, Waypoint, WaypointEdit, WaypointOffscreen).stream().map(TextureCache::getTexture);
        Arrays.asList(ColorPicker, ColorPicker2, GridSquares, GridRegion, GridRegionSquares, TileSampleDay, TileSampleNight, TileSampleUnderground, UnknownEntity).stream().map(TextureCache::getTexture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purgeThemeImages(Map<String, Texture> themeImages) {
        Map<String, Texture> map = themeImages;
        synchronized (map) {
            ExpireTextureTask.queue(themeImages.values());
            themeImages.clear();
        }
    }

    public static class_1011 resolveImage(class_2960 location) {
        if (location.method_12836().equals("fake")) {
            return null;
        }
        class_3300 resourceManager = class_310.method_1551().method_1478();
        try {
            class_3298 resource = resourceManager.method_14486(location).orElse(null);
            InputStream is = resource.method_14482();
            return class_1011.method_4309((InputStream)is);
        }
        catch (FileNotFoundException e) {
            try {
                class_3298 imgFile;
                if ("journeymap".equals(location.method_12836()) && (imgFile = (class_3298)class_310.method_1551().method_1478().method_14486(class_2960.method_60654((String)("../src/main/resources/assets/journeymap/" + location.method_12832()))).orElse(null)) != null) {
                    return class_1011.method_4309((InputStream)imgFile.method_14482());
                }
            }
            catch (IOException ioe) {
                Journeymap.getLogger().warn("Image not found: " + ioe.getMessage());
            }
            return null;
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Resource not readable: {}", (Object)location);
            return null;
        }
    }

    public static Texture getThemeTexture(Theme theme, String iconPath) {
        return TextureCache.getSizedThemeTexture(theme, iconPath, 0, 0, false, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Texture getThemeTextureFromResource(class_2960 icon) {
        Map<String, Texture> map = themeImages;
        synchronized (map) {
            Texture tex = themeImages.get(icon.toString());
            if (tex == null || !tex.hasImage()) {
                class_1011 nativeImage;
                if (tex != null) {
                    tex.remove();
                }
                if ((nativeImage = TextureCache.resolveImage(icon)) != null && nativeImage.field_4988 > 0L) {
                    tex = new DynamicTextureImpl(nativeImage);
                    tex.setAlpha(1.0f);
                    themeImages.put(icon.toString(), tex);
                } else {
                    Journeymap.getLogger().error("Unknown theme image: {}", (Object)icon);
                    IconSetFileHandler.ensureEntityIconSet("Default");
                    return TextureCache.getTexture(UnknownEntity);
                }
            }
            return tex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Texture getSizedThemeTexture(Theme theme, String iconPath, int width, int height, boolean resize, float alpha) {
        String texName = String.format("%s/%s", theme.directory, iconPath);
        Map<String, Texture> map = themeImages;
        synchronized (map) {
            Texture tex = themeImages.get(texName);
            if (tex == null || !tex.hasImage() || resize && (width != tex.getWidth() || height != tex.getHeight()) || tex.getAlpha() != alpha) {
                File parentDir;
                class_1011 nativeImage;
                if (tex != null) {
                    tex.remove();
                }
                if ((nativeImage = FileHandler.getIconFromFile(parentDir = ThemeLoader.getThemeIconDir(), theme.directory, iconPath)) == null) {
                    String resourcePath = String.format("theme/%s/%s", theme.directory, iconPath);
                    nativeImage = TextureCache.resolveImage(class_2960.method_60655((String)"journeymap", (String)resourcePath));
                }
                if (nativeImage != null && nativeImage.field_4988 > 0L) {
                    if ((resize || alpha < 1.0f) && (alpha < 1.0f || nativeImage.method_4307() != width || nativeImage.method_4323() != height)) {
                        class_1011 tmp = ImageUtil.getSizedImage(width, height, nativeImage, false);
                        nativeImage.close();
                        nativeImage = tmp;
                    }
                    tex = new DynamicTextureImpl(nativeImage);
                    tex.setAlpha(alpha);
                    themeImages.put(texName, tex);
                } else {
                    Journeymap.getLogger().error("Unknown theme image: " + texName);
                    IconSetFileHandler.ensureEntityIconSet("Default");
                    return TextureCache.getTexture(UnknownEntity);
                }
            }
            return tex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Texture getScaledCopy(String texName, Texture original, int width, int height, float alpha) {
        Map<String, Texture> map = themeImages;
        synchronized (map) {
            try {
                Texture tex = themeImages.get(texName);
                if (tex == null || !tex.hasImage() || width != tex.getWidth() || height != tex.getHeight() || tex.getAlpha() != alpha) {
                    if (original == null) {
                        Journeymap.getLogger().error("Unable to get scaled image: " + texName);
                        return TextureCache.getTexture(UnknownEntity);
                    }
                    if (!(alpha < 1.0f) && original.getWidth() == width && original.getHeight() == height) {
                        return original;
                    }
                    tex = new DynamicTextureImpl(ImageUtil.getSizedImage(width, height, original.getNativeImage(), true));
                    tex.setAlpha(alpha);
                    themeImages.put(texName, tex);
                }
                return tex;
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Unable to get scaled image: {}", (Object)texName, (Object)e);
                return original;
            }
        }
    }

    public static Texture getColorizedWaypointIcon(String id) {
        ClientWaypointImpl holder = WaypointStore.getInstance().get(id);
        if (holder != null) {
            class_2960 location = holder.getTextureResource();
            int color = holder.getIconColor();
            class_1060 textureManager = class_310.method_1551().method_1531();
            if (holder.hasCustomIconColor() || "journeymap".equals(location.method_12836())) {
                SimpleTextureImpl image = new SimpleTextureImpl(location);
                if (colorizedWPIconMap.get(id) == null && image.hasImage()) {
                    class_1011 coloredImage = ImageUtil.recolorImage(image.getNativeImage(), color);
                    DynamicTextureImpl texture = new DynamicTextureImpl(coloredImage);
                    colorizedWPIconMap.put(id, texture);
                    image.close();
                    return texture;
                }
                return colorizedWPIconMap.get(id);
            }
            return (Texture)textureManager.method_34590(location, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Texture getPlayerSkin(GameProfile profile) {
        Texture tex = null;
        Map<String, Texture> map = playerSkins;
        synchronized (map) {
            tex = playerSkins.get(profile.getName());
            if (tex != null) {
                return tex;
            }
            class_1011 blank = new class_1011(24, 24, false);
            tex = new DynamicTextureImpl(blank);
            playerSkins.put(profile.getName(), tex);
        }
        Texture playerSkinTex = tex;
        class_1011 img = IgnSkin.getFaceImage(profile);
        if (img != null) {
            playerSkins.put(profile.getName(), new DynamicTextureImpl(img));
        } else {
            playerSkins.remove(profile.getName());
        }
        return playerSkinTex;
    }
}

