/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import journeymap.client.Constants;
import journeymap.common.properties.config.StringField;

public class RegionTileShaders
implements StringField.ValuesProvider {
    public static final List<String> REGION_SHADERS = List.of("default", "grayscale", "sepia_1", "sepia_2", "sepia_3");
    private static final Map<String, ShaderKeys> idMap = new HashMap<String, ShaderKeys>();
    private static final Map<String, ShaderKeys> keyMap = new HashMap<String, ShaderKeys>();

    public static String from(String key) {
        return keyMap.get(key).id();
    }

    @Override
    public List<String> getStrings() {
        return REGION_SHADERS.stream().map(value -> idMap.get(value).name()).toList();
    }

    @Override
    public String getDefaultString() {
        return idMap.get(REGION_SHADERS.get(0)).name();
    }

    @Override
    public String getTooltip(String value) {
        return keyMap.get(value).tooltip();
    }

    static {
        for (String id : REGION_SHADERS) {
            ShaderKeys shader = new ShaderKeys(id);
            idMap.put(id, shader);
            keyMap.put(shader.key(), shader);
        }
    }

    public record ShaderKeys(String id) {
        public String key() {
            return String.format("jm.common.map_filter.%s", this.id());
        }

        public String name() {
            return Constants.getString("jm.common.map_filter.%s", this.id());
        }

        public String tooltip() {
            return Constants.getString("jm.common.map_filter.%s.tooltip", this.id());
        }
    }
}

