/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.color;

import com.google.common.base.Joiner;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.services.Services;
import journeymap.client.Constants;
import journeymap.client.cartography.color.ColorPalette;
import journeymap.client.cartography.color.ColoredSprite;
import journeymap.client.cartography.color.RGB;
import journeymap.client.model.BlockMD;
import journeymap.client.task.multi.MapPlayerTask;
import journeymap.common.Journeymap;
import net.minecraft.class_1011;
import net.minecraft.class_3288;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public enum ColorManager {
    INSTANCE;

    private Logger logger = Journeymap.getLogger();
    private volatile ColorPalette defaultPalette;
    private volatile ColorPalette globalPalette;
    private volatile ColorPalette worldPalette;
    private HashMap<String, float[]> iconColorCache = new HashMap();
    private String lastResourcePackNames;
    private String lastModNames;

    public static String getResourcePackNames() {
        String packs;
        Collection entries = Constants.getResourcePacks().method_14444();
        if (entries.isEmpty()) {
            packs = Constants.RESOURCE_PACKS_DEFAULT;
        } else {
            ArrayList<String> entryStrings = new ArrayList<String>(entries.size());
            for (class_3288 entry : entries) {
                entryStrings.add(entry.method_14457().getString());
            }
            packs = Joiner.on((String)", ").join(entryStrings);
        }
        return packs;
    }

    public void ensureCurrent() {
        if (this.defaultPalette == null) {
            return;
        }
        if (!this.defaultPaletteIsCurrent()) {
            this.regenerateDefaultPalette();
        }
    }

    public void loadPalettes() {
        boolean loaded = false;
        if (this.defaultPalette == null) {
            this.initDefaultBlockColors();
            loaded = true;
        }
        if (this.globalPalette == null) {
            this.globalPalette = ColorPalette.getGlobalColorPalette();
            if (this.globalPalette == null) {
                this.globalPalette = ColorPalette.create(ColorPalette.Type.Global);
            } else {
                loaded = true;
            }
        }
        if (this.worldPalette == null) {
            this.worldPalette = ColorPalette.getWorldColorPalette();
            if (this.worldPalette == null) {
                this.worldPalette = ColorPalette.create(ColorPalette.Type.World);
            } else {
                loaded = true;
            }
        }
        if (this.defaultPalette == null || this.globalPalette == null || this.worldPalette == null) {
            this.defaultPalette = null;
            this.globalPalette = null;
            this.worldPalette = null;
            return;
        }
        if (loaded) {
            this.applyColors();
        }
    }

    public ColorPalette getDefaultPalette() {
        return this.defaultPalette;
    }

    public ColorPalette getGlobalPalette() {
        return this.globalPalette;
    }

    public ColorPalette getWorldPalette() {
        return this.worldPalette;
    }

    public void savePalettes() {
        this.globalPalette.writeToFile();
        this.worldPalette.writeToFile();
    }

    public void closePalettes() {
        if (this.globalPalette != null) {
            this.globalPalette.writeToFile();
        }
        if (this.worldPalette != null) {
            this.worldPalette.writeToFile();
        }
        this.globalPalette = null;
        this.worldPalette = null;
    }

    public void regenerateDefaultPalette() {
        this.defaultPalette = null;
        this.initDefaultBlockColors();
        this.applyColors();
    }

    public void addNewBlockStateColor(BlockMD blockMD) {
        if (this.defaultPalette == null) {
            return;
        }
        blockMD.clearColor();
        this.defaultPalette.addBlockStateColor(blockMD, blockMD.generateColor());
        this.applyColor(blockMD);
    }

    private void initDefaultBlockColors() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            this.logger.error("ColorManager.initDefaultBlockColors() must be called on main thread!");
            return;
        }
        BlockMD.getAll();
        this.iconColorCache.clear();
        this.defaultPalette = ColorPalette.create(ColorPalette.Type.Default);
        if (this.defaultPalette != null) {
            this.lastResourcePackNames = ColorManager.getResourcePackNames();
            this.lastModNames = Services.COMMON_SERVICE.getModNames();
        }
    }

    private boolean defaultPaletteIsCurrent() {
        String currentResourcePackNames = ColorManager.getResourcePackNames();
        String currentModNames = Services.COMMON_SERVICE.getModNames();
        if (!currentResourcePackNames.equals(this.lastResourcePackNames)) {
            this.logger.debug("Resource Pack(s) changed: " + currentResourcePackNames);
            return false;
        }
        if (!currentModNames.equals(this.lastModNames)) {
            this.logger.debug("Mod Pack(s) changed: " + currentModNames);
            return false;
        }
        return true;
    }

    public void applyColors() {
        if (this.defaultPalette == null) {
            return;
        }
        this.actuallyApplyColors();
    }

    private void actuallyApplyColors() {
        Set<BlockMD> blockMDs = BlockMD.getAll();
        blockMDs.forEach(BlockMD::clearColor);
        for (BlockMD blockMD : blockMDs) {
            if (!this.defaultPalette.hasBlockStateColor(blockMD)) {
                this.defaultPalette.addBlockStateColor(blockMD, blockMD.generateColor());
            }
            this.applyColor(blockMD);
        }
        MapPlayerTask.forceNearbyRemap();
    }

    private void applyColor(BlockMD blockMD) {
        if (this.worldPalette != null && this.worldPalette.hasBlockStateColor(blockMD)) {
            this.worldPalette.applyColor(blockMD);
        } else if (this.globalPalette != null && this.globalPalette.hasBlockStateColor(blockMD)) {
            this.globalPalette.applyColor(blockMD);
        } else {
            this.defaultPalette.applyColor(blockMD);
        }
    }

    @Nullable
    public float[] getAverageColor(Collection<ColoredSprite> sprites) {
        float[] rgba;
        if (sprites == null || sprites.isEmpty()) {
            return null;
        }
        List names = sprites.stream().map(ColoredSprite::getIconName).collect(Collectors.toList());
        Collections.sort(names);
        String name = Joiner.on((String)",").join(names);
        if (this.iconColorCache.containsKey(name)) {
            rgba = this.iconColorCache.get(name);
        } else {
            rgba = this.calculateAverageColor(sprites);
            if (rgba != null) {
                this.iconColorCache.put(name, rgba);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(String.format("Cached color %s for %s", RGB.toHexString(RGB.toInteger(rgba)), name));
                }
            }
        }
        return rgba;
    }

    private float[] calculateAverageColor(Collection<ColoredSprite> sprites) {
        ArrayList<class_1011> images = new ArrayList<class_1011>(sprites.size());
        for (ColoredSprite coloredSprite : sprites) {
            class_1011 img = coloredSprite.getColoredImage();
            if (img == null) continue;
            images.add(img);
        }
        if (images.isEmpty()) {
            return null;
        }
        int count = 0;
        int b = 0;
        int g = 0;
        int r = 0;
        int a = 0;
        for (class_1011 image : images) {
            try {
                int[] argbInts;
                for (int argb : argbInts = image.method_4322()) {
                    int alpha = argb >> 24 & 0xFF;
                    if (alpha <= 0) continue;
                    ++count;
                    a += alpha;
                    r += argb >> 16 & 0xFF;
                    g += argb >> 8 & 0xFF;
                    b += argb & 0xFF;
                }
            }
            catch (Exception e) {
            }
        }
        if (count > 0) {
            int rgb = RGB.toInteger(r / count, g / count, b / count);
            return RGB.floats(rgb, a / count);
        }
        return null;
    }
}

