/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu;

import com.google.common.collect.LinkedListMultimap;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import com.terraformersmc.modmenu.api.UpdateChecker;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.config.ModMenuConfigManager;
import com.terraformersmc.modmenu.event.ModMenuEventHandler;
import com.terraformersmc.modmenu.util.EnumToLowerCaseJsonConverter;
import com.terraformersmc.modmenu.util.ModMenuScreenTexts;
import com.terraformersmc.modmenu.util.UpdateCheckerUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.fabric.FabricDummyParentMod;
import com.terraformersmc.modmenu.util.mod.fabric.FabricMod;
import com.terraformersmc.modmenu.util.mod.quilt.QuiltMod;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModMenu
implements ClientModInitializer {
    public static final String MOD_ID = "modmenu";
    public static final String GITHUB_REF = "TerraformersMC/ModMenu";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu");
    public static final Gson GSON;
    public static final Gson GSON_MINIFIED;
    public static final Map<String, Mod> MODS;
    public static final Map<String, Mod> ROOT_MODS;
    public static final LinkedListMultimap<Mod, Mod> PARENT_MAP;
    private static final Map<String, ConfigScreenFactory<?>> configScreenFactories;
    private static final List<ModMenuApi> apiImplementations;
    private static int cachedDisplayedModCount;
    public static final boolean RUNNING_QUILT;
    public static final boolean DEV_ENVIRONMENT;
    public static final boolean TEXT_PLACEHOLDER_COMPAT;

    public static class_437 getConfigScreen(String modid, class_437 menuScreen) {
        for (ModMenuApi api : apiImplementations) {
            Map<String, ConfigScreenFactory<?>> factoryProviders = api.getProvidedConfigScreenFactories();
            if (factoryProviders.isEmpty()) continue;
            factoryProviders.forEach(configScreenFactories::putIfAbsent);
        }
        if (ModMenuConfig.HIDDEN_CONFIGS.getValue().contains(modid)) {
            return null;
        }
        ConfigScreenFactory<?> factory = configScreenFactories.get(modid);
        if (factory != null) {
            return factory.create(menuScreen);
        }
        return null;
    }

    public void onInitializeClient() {
        ModMenuConfigManager.initializeConfig();
        HashSet<String> modpackMods = new HashSet<String>();
        HashMap updateCheckers = new HashMap();
        HashMap providedUpdateCheckers = new HashMap();
        FabricLoader.getInstance().getEntrypointContainers(MOD_ID, ModMenuApi.class).forEach(entrypoint -> {
            ModMetadata metadata = entrypoint.getProvider().getMetadata();
            String modId = metadata.getId();
            try {
                ModMenuApi api = (ModMenuApi)entrypoint.getEntrypoint();
                configScreenFactories.put(modId, api.getModConfigScreenFactory());
                apiImplementations.add(api);
                updateCheckers.put(modId, api.getUpdateChecker());
                providedUpdateCheckers.putAll(api.getProvidedUpdateCheckers());
                api.attachModpackBadges(modpackMods::add);
            }
            catch (Throwable e) {
                LOGGER.error("Mod {} provides a broken implementation of ModMenuApi", (Object)modId, (Object)e);
            }
        });
        for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
            Mod mod = RUNNING_QUILT ? new QuiltMod(modContainer, modpackMods) : new FabricMod(modContainer, modpackMods);
            UpdateChecker updateChecker = (UpdateChecker)updateCheckers.get(mod.getId());
            if (updateChecker == null) {
                updateChecker = (UpdateChecker)providedUpdateCheckers.get(mod.getId());
            }
            MODS.put(mod.getId(), mod);
            mod.setUpdateChecker(updateChecker);
        }
        ModMenu.checkForUpdates();
        HashMap<String, Mod> dummyParents = new HashMap<String, Mod>();
        for (Mod mod : MODS.values()) {
            String parentId = mod.getParent();
            if (parentId != null) {
                Mod parent = MODS.getOrDefault(parentId, (Mod)dummyParents.get(parentId));
                if (parent == null && mod instanceof FabricMod) {
                    parent = new FabricDummyParentMod((FabricMod)mod, parentId);
                    dummyParents.put(parentId, parent);
                }
                PARENT_MAP.put((Object)parent, (Object)mod);
                continue;
            }
            ROOT_MODS.put(mod.getId(), mod);
        }
        MODS.putAll(dummyParents);
        ModMenuEventHandler.register();
    }

    public static void clearModCountCache() {
        cachedDisplayedModCount = -1;
    }

    public static void checkForUpdates() {
        UpdateCheckerUtil.checkForUpdates();
    }

    public static boolean areModUpdatesAvailable() {
        if (!ModMenuConfig.UPDATE_CHECKER.getValue()) {
            return false;
        }
        for (Mod mod : MODS.values()) {
            if (mod.isHidden() || !ModMenuConfig.SHOW_LIBRARIES.getValue() && mod.getBadges().contains((Object)Mod.Badge.LIBRARY) || !mod.hasUpdate() && !mod.getChildHasUpdate()) continue;
            return true;
        }
        return false;
    }

    public static String getDisplayedModCount() {
        if (cachedDisplayedModCount == -1) {
            boolean includeChildren = ModMenuConfig.COUNT_CHILDREN.getValue();
            boolean includeLibraries = ModMenuConfig.COUNT_LIBRARIES.getValue();
            boolean includeHidden = ModMenuConfig.COUNT_HIDDEN_MODS.getValue();
            cachedDisplayedModCount = Math.toIntExact(MODS.values().stream().filter(mod -> {
                boolean isChild;
                boolean bl = isChild = mod.getParent() != null;
                if (!includeChildren && isChild) {
                    return false;
                }
                boolean isLibrary = mod.getBadges().contains((Object)Mod.Badge.LIBRARY);
                if (!includeLibraries && isLibrary) {
                    return false;
                }
                return includeHidden || !mod.isHidden();
            }).count());
        }
        return NumberFormat.getInstance().format(cachedDisplayedModCount);
    }

    public static class_2561 createModsButtonText(boolean title) {
        boolean isIcon;
        ModMenuConfig.TitleMenuButtonStyle titleStyle = ModMenuConfig.MODS_BUTTON_STYLE.getValue();
        ModMenuConfig.GameMenuButtonStyle gameMenuStyle = ModMenuConfig.GAME_MENU_BUTTON_STYLE.getValue();
        boolean bl = title ? titleStyle == ModMenuConfig.TitleMenuButtonStyle.ICON : (isIcon = gameMenuStyle == ModMenuConfig.GameMenuButtonStyle.ICON);
        boolean isShort = title ? titleStyle == ModMenuConfig.TitleMenuButtonStyle.SHRINK : gameMenuStyle == ModMenuConfig.GameMenuButtonStyle.REPLACE;
        class_5250 modsText = ModMenuScreenTexts.TITLE.method_27661();
        if (ModMenuConfig.MOD_COUNT_LOCATION.getValue().isOnModsButton() && !isIcon) {
            String count = ModMenu.getDisplayedModCount();
            if (isShort) {
                modsText.method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43469((String)"modmenu.loaded.short", (Object[])new Object[]{count}));
            } else {
                Object key;
                String specificKey = "modmenu.loaded." + count;
                Object object = key = class_1074.method_4663((String)specificKey) ? specificKey : "modmenu.loaded";
                if (ModMenuConfig.EASTER_EGGS.getValue() && class_1074.method_4663((String)(specificKey + ".secret"))) {
                    key = specificKey + ".secret";
                }
                modsText.method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43469((String)key, (Object[])new Object[]{count}));
            }
        }
        return modsText;
    }

    static {
        GsonBuilder builder = new GsonBuilder().registerTypeHierarchyAdapter(Enum.class, (Object)new EnumToLowerCaseJsonConverter()).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        GSON = builder.setPrettyPrinting().create();
        GSON_MINIFIED = builder.create();
        MODS = new HashMap<String, Mod>();
        ROOT_MODS = new HashMap<String, Mod>();
        PARENT_MAP = LinkedListMultimap.create();
        configScreenFactories = new HashMap();
        apiImplementations = new ArrayList<ModMenuApi>();
        cachedDisplayedModCount = -1;
        RUNNING_QUILT = FabricLoader.getInstance().isModLoaded("quilt_loader");
        DEV_ENVIRONMENT = FabricLoader.getInstance().isDevelopmentEnvironment();
        TEXT_PLACEHOLDER_COMPAT = FabricLoader.getInstance().isModLoaded("placeholder-api");
    }
}

