/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block;

import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TintGetterOverrideSmooth
implements BlockAndTintGetter {
    LevelReader parent;
    public int smoothingRange;

    public TintGetterOverrideSmooth(LevelReader parent, int smoothingRange) {
        this.parent = parent;
        this.smoothingRange = smoothingRange;
    }

    private Biome _getBiome(BlockPos pos) {
        return (Biome)this.parent.getBiome(pos).value();
    }

    public int calculateBlockTint(BlockPos blockPos, ColorResolver colorResolver) {
        int i = this.smoothingRange;
        if (i == 0) {
            return colorResolver.getColor(this._getBiome(blockPos), (double)blockPos.getX(), (double)blockPos.getZ());
        }
        int j = (i * 2 + 1) * (i * 2 + 1);
        int k = 0;
        int l = 0;
        int m = 0;
        Cursor3D cursor3D = new Cursor3D(blockPos.getX() - i, blockPos.getY(), blockPos.getZ() - i, blockPos.getX() + i, blockPos.getY(), blockPos.getZ() + i);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        while (cursor3D.advance()) {
            mutableBlockPos.set(cursor3D.nextX(), cursor3D.nextY(), cursor3D.nextZ());
            int n = colorResolver.getColor(this._getBiome((BlockPos)mutableBlockPos), (double)mutableBlockPos.getX(), (double)mutableBlockPos.getZ());
            k += (n & 0xFF0000) >> 16;
            l += (n & 0xFF00) >> 8;
            m += n & 0xFF;
        }
        return (k / j & 0xFF) << 16 | (l / j & 0xFF) << 8 | m / j & 0xFF;
    }

    public int getBlockTint(BlockPos blockPos, ColorResolver colorResolver) {
        return this.calculateBlockTint(blockPos, colorResolver);
    }

    public float getShade(Direction direction, boolean bl) {
        return this.parent.getShade(direction, bl);
    }

    public LevelLightEngine getLightEngine() {
        return this.parent.getLightEngine();
    }

    public int getBrightness(LightLayer lightLayer, BlockPos blockPos) {
        return this.parent.getBrightness(lightLayer, blockPos);
    }

    public int getRawBrightness(BlockPos blockPos, int i) {
        return this.parent.getRawBrightness(blockPos, i);
    }

    public boolean canSeeSky(BlockPos blockPos) {
        return this.parent.canSeeSky(blockPos);
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos blockPos) {
        return this.parent.getBlockEntity(blockPos);
    }

    public BlockState getBlockState(BlockPos blockPos) {
        return this.parent.getBlockState(blockPos);
    }

    public FluidState getFluidState(BlockPos blockPos) {
        return this.parent.getFluidState(blockPos);
    }

    public int getLightEmission(BlockPos blockPos) {
        return this.parent.getLightEmission(blockPos);
    }

    public int getMaxLightLevel() {
        return this.parent.getMaxLightLevel();
    }

    public Stream<BlockState> getBlockStates(AABB aABB) {
        return this.parent.getBlockStates(aABB);
    }

    public BlockHitResult clip(ClipContext clipContext) {
        return this.parent.clip(clipContext);
    }

    @Nullable
    public BlockHitResult clipWithInteractionOverride(Vec3 vec3, Vec3 vec32, BlockPos blockPos, VoxelShape voxelShape, BlockState blockState) {
        return this.parent.clipWithInteractionOverride(vec3, vec32, blockPos, voxelShape, blockState);
    }

    public double getBlockFloorHeight(VoxelShape voxelShape, Supplier<VoxelShape> supplier) {
        return this.parent.getBlockFloorHeight(voxelShape, supplier);
    }

    public double getBlockFloorHeight(BlockPos blockPos) {
        return this.parent.getBlockFloorHeight(blockPos);
    }

    public int getMaxBuildHeight() {
        return this.parent.getMaxBuildHeight();
    }

    public <T extends BlockEntity> Optional<T> getBlockEntity(BlockPos blockPos, BlockEntityType<T> blockEntityType) {
        return this.parent.getBlockEntity(blockPos, blockEntityType);
    }

    public BlockHitResult isBlockInLine(ClipBlockStateContext clipBlockStateContext) {
        return this.parent.isBlockInLine(clipBlockStateContext);
    }

    public int getHeight() {
        return this.parent.getHeight();
    }

    public int getMinBuildHeight() {
        return this.parent.getMinBuildHeight();
    }

    public int getSectionsCount() {
        return this.parent.getSectionsCount();
    }

    public int getMinSection() {
        return this.parent.getMinSection();
    }

    public int getMaxSection() {
        return this.parent.getMaxSection();
    }

    public boolean isOutsideBuildHeight(BlockPos blockPos) {
        return this.parent.isOutsideBuildHeight(blockPos);
    }

    public boolean isOutsideBuildHeight(int i) {
        return this.parent.isOutsideBuildHeight(i);
    }

    public int getSectionIndex(int i) {
        return this.parent.getSectionIndex(i);
    }

    public int getSectionIndexFromSectionY(int i) {
        return this.parent.getSectionIndexFromSectionY(i);
    }

    public int getSectionYFromSectionIndex(int i) {
        return this.parent.getSectionYFromSectionIndex(i);
    }
}

