/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.gridList;

import com.seibel.distanthorizons.core.pos.Pos2D;
import com.seibel.distanthorizons.core.util.gridList.ArrayGridList;
import com.seibel.distanthorizons.core.util.gridList.PosArrayGridList;
import com.seibel.distanthorizons.core.util.objects.BoolType;
import java.util.Iterator;
import java.util.function.IntPredicate;

public class EdgeDistanceBooleanGrid
extends PosArrayGridList<BoolType> {
    ArrayGridList<Integer> edgeCache = null;

    public EdgeDistanceBooleanGrid(Iterator<Pos2D> posIter, int offsetX, int offsetY, int gridSize) {
        super(gridSize, offsetX, offsetY);
        while (posIter.hasNext()) {
            Pos2D p = posIter.next();
            this.set(p, BoolType.TRUE);
        }
    }

    private static boolean updatePos(ArrayGridList<Integer> grid, int ox, int oy) {
        if (grid.get(ox, oy) < 0) {
            return true;
        }
        if (ox == 0 || oy == 0 || ox == grid.gridSize - 1 || oy == grid.gridSize - 1) {
            return true;
        }
        int v = grid.get(ox, oy);
        if (grid.get(ox, oy + 1) < v || grid.get(ox, oy - 1) < v || grid.get(ox + 1, oy) < v || grid.get(ox - 1, oy) < v) {
            return true;
        }
        grid.set(ox, oy, v + 1);
        return false;
    }

    private void computeEdgeCache() {
        if (this.edgeCache != null) {
            return;
        }
        this.edgeCache = new ArrayGridList<Integer>(this.gridSize, (ox, oy) -> {
            BoolType b = (BoolType)this.get(ox + this.getOffsetX(), oy + this.getOffsetY());
            return b == null ? -1 : 0;
        });
        boolean[] isDone = new boolean[]{false};
        while (!isDone[0]) {
            isDone[0] = true;
            this.edgeCache.forEachPos((ox, oy) -> {
                isDone[0] = isDone[0] & EdgeDistanceBooleanGrid.updatePos(this.edgeCache, ox, oy);
            });
        }
    }

    public <T extends ArrayGridList<BoolType>> void flagAllWithDistance(T list, IntPredicate predicate) {
        this.computeEdgeCache();
        this.edgeCache.forEachPos((ox, oy) -> {
            int v = this.edgeCache.get((int)ox, (int)oy);
            if (v < 0 || !predicate.test(v)) {
                return;
            }
            list.set(ox + this.getOffsetX(), oy + this.getOffsetY(), BoolType.TRUE);
        });
    }
}

