/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.jar.installer;

import DistantHorizons.libraries.electronwill.nightconfig.core.Config;
import com.seibel.distanthorizons.core.jar.installer.WebDownloader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModrinthGetter {
    public static final String ModrinthAPI = "https://api.modrinth.com/v2/project/";
    public static final String projectID = "distanthorizons";
    public static boolean initted = false;
    public static ArrayList<Config> projectRelease;
    public static Map<String, Config> idToJson;
    public static List<String> releaseID;
    public static List<String> mcVersions;
    public static Map<String, String> releaseNames;
    public static Map<String, List<String>> mcVerToReleaseID;
    public static Map<String, URL> downloadUrl;
    public static Map<String, String> changeLogs;

    public static boolean init() {
        try {
            initted = false;
            projectRelease = WebDownloader.parseWebJsonList("https://api.modrinth.com/v2/project/distanthorizons/version");
            for (Config currentRelease : projectRelease) {
                String workingID = currentRelease.get("id").toString();
                releaseID.add(workingID);
                idToJson.put(workingID, currentRelease);
                releaseNames.put(workingID, currentRelease.get("name").toString().replaceAll(" - 1\\..*", ""));
                changeLogs.put(workingID, currentRelease.get("changelog").toString());
                try {
                    downloadUrl.put(workingID, new URL(((Config)((ArrayList)currentRelease.get("files")).get(0)).get("url").toString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                for (String mcVer : (List)currentRelease.get("game_versions")) {
                    if (!mcVersions.contains(mcVer)) {
                        mcVersions.add(mcVer);
                        mcVerToReleaseID.put(mcVer, new ArrayList());
                    }
                    mcVerToReleaseID.get(mcVer).add(workingID);
                }
            }
            Collections.sort(mcVersions);
            Collections.reverse(mcVersions);
            initted = true;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getLatestIDForVersion(String mcVer) {
        try {
            return mcVerToReleaseID.get(mcVer).get(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getLatestNameForVersion(String mcVer) {
        return releaseNames.get(mcVerToReleaseID.get(mcVer).get(0));
    }

    public static URL getLatestDownloadForVersion(String mcVer) {
        return downloadUrl.get(mcVerToReleaseID.get(mcVer).get(0));
    }

    public static String getLatestShaForVersion(String mcVer) {
        return ((Config)((ArrayList)idToJson.get(mcVerToReleaseID.get(mcVer).get(0)).get("files")).get(0)).get("hashes.sha1").toString();
    }

    static {
        idToJson = new HashMap<String, Config>();
        releaseID = new ArrayList<String>();
        mcVersions = new ArrayList<String>();
        releaseNames = new HashMap<String, String>();
        mcVerToReleaseID = new HashMap<String, List<String>>();
        downloadUrl = new HashMap<String, URL>();
        changeLogs = new HashMap<String, String>();
    }
}

