/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.transformers;

import com.seibel.distanthorizons.api.enums.config.EDhApiBlocksToAvoid;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.FullDataPointIdMap;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderSource;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnArrayView;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.FullDataPointUtil;
import com.seibel.distanthorizons.core.util.RenderDataPointUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.HashSet;
import org.apache.logging.log4j.Logger;

public class FullDataToRenderDataTransformer {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IWrapperFactory WRAPPER_FACTORY = SingletonInjector.INSTANCE.get(IWrapperFactory.class);
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final LongOpenHashSet brokenPos = new LongOpenHashSet();

    public static ColumnRenderSource transformFullDataToRenderSource(FullDataSourceV2 fullDataSource, IDhClientLevel level) {
        if (fullDataSource == null) {
            return null;
        }
        if (level == null) {
            return null;
        }
        try {
            return FullDataToRenderDataTransformer.transformCompleteFullDataToColumnData(level, fullDataSource);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    private static ColumnRenderSource transformCompleteFullDataToColumnData(IDhClientLevel level, FullDataSourceV2 fullDataSource) throws InterruptedException {
        long pos = fullDataSource.getPos();
        byte dataDetail = fullDataSource.getDataDetailLevel();
        int vertSize = Config.Client.Advanced.Graphics.Quality.verticalQuality.get().calculateMaxVerticalData(fullDataSource.getDataDetailLevel());
        ColumnRenderSource columnSource = ColumnRenderSource.getPooledRenderSource(pos, vertSize, level.getMinY(), true);
        if (fullDataSource.isEmpty) {
            return columnSource;
        }
        columnSource.markNotEmpty();
        if (dataDetail == columnSource.getDataDetailLevel()) {
            int baseX = DhSectionPos.getMinCornerBlockX(pos);
            int baseZ = DhSectionPos.getMinCornerBlockZ(pos);
            for (int x = 0; x < DhSectionPos.getWidthCountForLowerDetailedSection(pos, dataDetail); ++x) {
                for (int z = 0; z < DhSectionPos.getWidthCountForLowerDetailedSection(pos, dataDetail); ++z) {
                    FullDataToRenderDataTransformer.throwIfThreadInterrupted();
                    ColumnArrayView columnArrayView = columnSource.getVerticalDataPointView(x, z);
                    LongArrayList dataColumn = fullDataSource.get(x, z);
                    FullDataToRenderDataTransformer.convertColumnData(level, fullDataSource.mapping, baseX + x, baseZ + z, columnArrayView, dataColumn);
                }
            }
        } else {
            throw new UnsupportedOperationException("To be implemented");
        }
        columnSource.fillDebugFlag(0, 0, ColumnRenderSource.SECTION_SIZE, ColumnRenderSource.SECTION_SIZE, ColumnRenderSource.DebugSourceFlag.FULL);
        return columnSource;
    }

    private static void throwIfThreadInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException(FullDataToRenderDataTransformer.class.getSimpleName() + " task interrupted.");
        }
    }

    private static void iterateAndConvert(IDhClientLevel level, FullDataPointIdMap fullDataMapping, int blockX, int blockZ, ColumnArrayView renderColumnData, LongArrayList fullColumnData) {
        boolean avoidSolidBlocks = Config.Client.Advanced.Graphics.Quality.blocksToIgnore.get() == EDhApiBlocksToAvoid.NON_COLLIDING;
        boolean colorBelowWithAvoidedBlocks = Config.Client.Advanced.Graphics.Quality.tintWithAvoidedBlocks.get();
        HashSet<IBlockStateWrapper> blockStatesToIgnore = WRAPPER_FACTORY.getRendererIgnoredBlocks(level.getLevelWrapper());
        boolean isVoid = true;
        int colorToApplyToNextBlock = -1;
        int lastColor = 0;
        int lastBottom = -10000;
        int skylightToApplyToNextBlock = -1;
        int blocklightToApplyToNextBlock = -1;
        int columnOffset = 0;
        for (int i = 0; i < fullColumnData.size(); ++i) {
            long columnData;
            int color;
            IBlockStateWrapper block;
            IBiomeWrapper biome;
            long fullData = fullColumnData.getLong(i);
            int bottomY = FullDataPointUtil.getBottomY(fullData);
            int blockHeight = FullDataPointUtil.getHeight(fullData);
            int id = FullDataPointUtil.getId(fullData);
            int blockLight = FullDataPointUtil.getBlockLight(fullData);
            int skyLight = FullDataPointUtil.getSkyLight(fullData);
            try {
                biome = fullDataMapping.getBiomeWrapper(id);
                block = fullDataMapping.getBlockStateWrapper(id);
            }
            catch (IndexOutOfBoundsException e) {
                if (brokenPos.contains(fullDataMapping.getPos())) continue;
                brokenPos.add(fullDataMapping.getPos());
                String dimName = level.getLevelWrapper().getDimensionType().getDimensionName();
                LOGGER.warn("Unable to get data point with id [" + id + "] (Max possible ID: [" + fullDataMapping.getMaxValidId() + "]) for pos [" + fullDataMapping.getPos() + "] in dimension [" + dimName + "]. Error: [" + e.getMessage() + "]. Further errors for this position won't be logged.");
                continue;
            }
            if (blockStatesToIgnore.contains(block)) continue;
            if (avoidSolidBlocks && !block.isSolid() && !block.isLiquid() && block.getOpacity() != 16) {
                int tempColor;
                if (!colorBelowWithAvoidedBlocks || ColorUtil.getAlpha(tempColor = level.computeBaseColor(new DhBlockPos(blockX, bottomY + level.getMinY(), blockZ), biome, block)) == 0) continue;
                colorToApplyToNextBlock = ColorUtil.setAlpha(tempColor, 255);
                skylightToApplyToNextBlock = skyLight;
                blocklightToApplyToNextBlock = blockLight;
                continue;
            }
            if (colorToApplyToNextBlock == -1) {
                color = level.computeBaseColor(new DhBlockPos(blockX, bottomY + level.getMinY(), blockZ), biome, block);
            } else {
                color = colorToApplyToNextBlock;
                colorToApplyToNextBlock = -1;
                skyLight = skylightToApplyToNextBlock;
                blockLight = blocklightToApplyToNextBlock;
            }
            if (color == lastColor && bottomY + blockHeight == lastBottom && columnOffset > 0) {
                columnData = renderColumnData.get(columnOffset - 1);
                columnData = RenderDataPointUtil.setYMin(columnData, bottomY);
                renderColumnData.set(columnOffset - 1, columnData);
            } else {
                isVoid = false;
                columnData = RenderDataPointUtil.createDataPoint(bottomY + blockHeight, bottomY, color, skyLight, blockLight, block.getIrisBlockMaterialId());
                renderColumnData.set(columnOffset, columnData);
                ++columnOffset;
            }
            lastBottom = bottomY;
            lastColor = color;
        }
        if (isVoid) {
            renderColumnData.set(0, RenderDataPointUtil.createVoidDataPoint());
        }
    }

    public static void convertColumnData(IDhClientLevel level, FullDataPointIdMap fullDataMapping, int blockX, int blockZ, ColumnArrayView columnArrayView, LongArrayList fullDataColumn) {
        if (fullDataColumn == null || fullDataColumn.size() == 0) {
            return;
        }
        int dataTotalLength = fullDataColumn.size();
        if (dataTotalLength > columnArrayView.verticalSize()) {
            ColumnArrayView totalColumnData = new ColumnArrayView(new LongArrayList(new long[dataTotalLength]), dataTotalLength, 0, dataTotalLength);
            FullDataToRenderDataTransformer.iterateAndConvert(level, fullDataMapping, blockX, blockZ, totalColumnData, fullDataColumn);
            columnArrayView.changeVerticalSizeFrom(totalColumnData);
        } else {
            FullDataToRenderDataTransformer.iterateAndConvert(level, fullDataMapping, blockX, blockZ, columnArrayView, fullDataColumn);
        }
    }
}

