/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.transformers;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dataObjects.transformers.LodDataBuilder;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;

public class ChunkToLodBuilder
implements AutoCloseable {
    public static final ConfigBasedLogger LOGGER = new ConfigBasedLogger(LogManager.getLogger(), () -> Config.Client.Advanced.Logging.logLodBuilderEvent.get());
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    public static final long MAX_TICK_TIME_NS = 50000000L;
    private final ConcurrentHashMap<DhChunkPos, IChunkWrapper> concurrentChunkToBuildByChunkPos = new ConcurrentHashMap();
    private final ConcurrentLinkedDeque<Task> concurrentTaskToBuildList = new ConcurrentLinkedDeque();
    private final AtomicInteger runningCount = new AtomicInteger(0);

    public CompletableFuture<FullDataSourceV2> tryGenerateData(IChunkWrapper chunkWrapper) {
        if (chunkWrapper == null) {
            throw new NullPointerException("ChunkWrapper cannot be null!");
        }
        IChunkWrapper oldChunk = this.concurrentChunkToBuildByChunkPos.put(chunkWrapper.getChunkPos(), chunkWrapper);
        if (oldChunk != null) {
            return null;
        }
        CompletableFuture<FullDataSourceV2> future = new CompletableFuture<FullDataSourceV2>();
        this.concurrentTaskToBuildList.addLast(new Task(chunkWrapper.getChunkPos(), future));
        return future;
    }

    public void tick() {
        int threadCount = ThreadPoolUtil.getWorkerThreadCount();
        if (this.runningCount.get() >= threadCount) {
            return;
        }
        if (this.concurrentTaskToBuildList.isEmpty()) {
            return;
        }
        if (MC == null || !MC.playerExists()) {
            return;
        }
        ThreadPoolExecutor lodBuilderExecutor = ThreadPoolUtil.getChunkToLodBuilderExecutor();
        if (lodBuilderExecutor == null) {
            return;
        }
        for (int i = 0; i < threadCount; ++i) {
            this.runningCount.incrementAndGet();
            try {
                CompletableFuture.runAsync(() -> {
                    try {
                        this.tickThreadTask();
                    }
                    finally {
                        this.runningCount.decrementAndGet();
                    }
                }, lodBuilderExecutor);
                continue;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    private void tickThreadTask() {
        long time = System.nanoTime();
        int count = 0;
        boolean allDone = false;
        while (System.nanoTime() - time <= 50000000L || this.concurrentTaskToBuildList.isEmpty()) {
            Task task = this.concurrentTaskToBuildList.pollFirst();
            if (task == null) {
                allDone = true;
                break;
            }
            ++count;
            IChunkWrapper latestChunk = this.concurrentChunkToBuildByChunkPos.remove(task.chunkPos);
            if (latestChunk == null) {
                LOGGER.error("Somehow Task at " + task.chunkPos + " has latestChunk as null. Skipping task.", new Object[0]);
                task.future.complete(null);
                continue;
            }
            try {
                if (LodDataBuilder.canGenerateLodFromChunk(latestChunk)) {
                    FullDataSourceV2 dataSource = LodDataBuilder.createGeneratedDataSource(latestChunk);
                    if (dataSource != null) {
                        task.future.complete(dataSource);
                        continue;
                    }
                } else if (task.generationAttemptExpirationTimeMs < System.currentTimeMillis()) {
                    continue;
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error while processing Task at " + task.chunkPos, ex);
            }
            IChunkWrapper casChunk = this.concurrentChunkToBuildByChunkPos.putIfAbsent(task.chunkPos, latestChunk);
            if (casChunk == null || latestChunk.isStillValid()) {
                this.concurrentTaskToBuildList.addLast(task);
            } else {
                task.future.complete(null);
            }
            --count;
        }
        long time2 = System.nanoTime();
        if (!allDone || count > 0) {
            // empty if block
        }
    }

    public void clearCurrentTasks() {
        this.concurrentTaskToBuildList.clear();
        this.concurrentChunkToBuildByChunkPos.clear();
    }

    @Override
    public void close() {
        this.clearCurrentTasks();
    }

    private static class Task {
        public final DhChunkPos chunkPos;
        public final CompletableFuture<FullDataSourceV2> future;
        public long generationAttemptExpirationTimeMs = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);

        Task(DhChunkPos chunkPos, CompletableFuture<FullDataSourceV2> future) {
            this.chunkPos = chunkPos;
            this.future = future;
        }
    }
}

