/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config.file;

import DistantHorizons.libraries.electronwill.nightconfig.core.Config;
import DistantHorizons.libraries.electronwill.nightconfig.core.io.ParsingMode;
import DistantHorizons.libraries.electronwill.nightconfig.json.JsonFormat;
import java.util.HashMap;
import java.util.Map;

public class ConfigTypeConverters {
    public static final Map<Class<?>, ConverterBase> convertObjects = new HashMap<Class<?>, ConverterBase>(){
        {
            this.put(Short.class, new ShortConverter());
            this.put(Long.class, new LongConverter());
            this.put(Float.class, new FloatConverter());
            this.put(Double.class, new DoubleConverter());
            this.put(Byte.class, new ByteConverter());
            this.put(Map.class, new MapConverter());
        }
    };

    public static Class<?> isClassConvertable(Class<?> clazz) {
        for (int i = 0; i < convertObjects.size(); ++i) {
            Class selectedClass = (Class)convertObjects.keySet().toArray()[i];
            if (!selectedClass.isAssignableFrom(clazz)) continue;
            return selectedClass;
        }
        return null;
    }

    public static Object attemptToConvertToString(Object value) {
        return ConfigTypeConverters.attemptToConvertToString(value.getClass(), value);
    }

    public static Object attemptToConvertToString(Class<?> clazz, Object value) {
        Class<?> convertablClass = ConfigTypeConverters.isClassConvertable(clazz);
        if (convertablClass != null) {
            return ConfigTypeConverters.convertToString(convertablClass, value);
        }
        return value;
    }

    public static Object attemptToConvertFromString(Object value) {
        return ConfigTypeConverters.attemptToConvertFromString(value.getClass(), value);
    }

    public static Object attemptToConvertFromString(Class<?> outputClass, Object value) {
        boolean valueNeedsConverting = value == null || value.getClass().equals(String.class);
        Class<?> convertablClass = ConfigTypeConverters.isClassConvertable(outputClass);
        if (valueNeedsConverting && convertablClass != null) {
            return ConfigTypeConverters.convertFromString(convertablClass, (String)value);
        }
        return value;
    }

    public static String convertToString(Class<?> clazz, Object value) {
        try {
            return convertObjects.get(clazz).convertToString(value);
        }
        catch (Exception e) {
            System.out.println("Type [" + clazz.toString() + "] isn't a convertible value in the config file handler");
            return null;
        }
    }

    public static Object convertFromString(Class<?> clazz, String value) {
        try {
            return convertObjects.get(clazz).convertFromString(value);
        }
        catch (Exception e) {
            System.out.println("Type [" + clazz.toString() + "] isn't a convertible value in the config file handler");
            return null;
        }
    }

    public static abstract class ConverterBase {
        public abstract String convertToString(Object var1);

        public abstract Object convertFromString(String var1);
    }

    public static class MapConverter
    extends ConverterBase {
        @Override
        public String convertToString(Object item) {
            Map mapObject = (Map)item;
            Config jsonObject = Config.inMemory();
            Object[] keyArray = mapObject.keySet().toArray();
            for (int i = 0; i < mapObject.size(); ++i) {
                jsonObject.add(keyArray[i].toString(), mapObject.get(keyArray[i]));
            }
            return JsonFormat.minimalInstance().createWriter().writeToString(jsonObject);
        }

        @Override
        public Map<String, Object> convertFromString(String s) {
            HashMap map = new HashMap();
            Config jsonObject = Config.inMemory();
            try {
                JsonFormat.minimalInstance().createParser().parse(s, jsonObject, ParsingMode.REPLACE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return jsonObject.valueMap();
        }
    }

    public static class ByteConverter
    extends ConverterBase {
        @Override
        public String convertToString(Object item) {
            return ((Byte)item).toString();
        }

        @Override
        public Byte convertFromString(String s) {
            return Byte.valueOf(s);
        }
    }

    public static class DoubleConverter
    extends ConverterBase {
        @Override
        public String convertToString(Object item) {
            return ((Double)item).toString();
        }

        @Override
        public Double convertFromString(String s) {
            return Double.valueOf(s);
        }
    }

    public static class FloatConverter
    extends ConverterBase {
        @Override
        public String convertToString(Object item) {
            return ((Float)item).toString();
        }

        @Override
        public Float convertFromString(String s) {
            return Float.valueOf(s);
        }
    }

    public static class LongConverter
    extends ConverterBase {
        @Override
        public String convertToString(Object item) {
            return ((Long)item).toString();
        }

        @Override
        public Long convertFromString(String s) {
            return Long.valueOf(s);
        }
    }

    public static class ShortConverter
    extends ConverterBase {
        @Override
        public String convertToString(Object item) {
            return ((Short)item).toString();
        }

        @Override
        public Short convertFromString(String s) {
            return Short.valueOf(s);
        }
    }
}

